from django import forms
from .models import CustomerLocation

class CustomerLocationForm(forms.ModelForm):
    class Meta:
        model = CustomerLocation
        fields = ['contract_number', 'acct_ktv', 'address_note']
        widgets = {
            'address_note': forms.Textarea(attrs={'rows': 3}),
            'acct_ktv': forms.TextInput(attrs={'readonly': 'readonly'}),
        } 