from django.db import models
from django.contrib.auth.models import User

# Create your models here.

class CustomerLocation(models.Model):
    contract_number = models.CharField(max_length=255, verbose_name="Số hợp đồng")
    user = models.ForeignKey(User, on_delete=models.CASCADE, db_column='user_id', verbose_name="Người nhập")
    acct_ktv = models.CharField(max_length=255, verbose_name="Account KTV")
    address_note = models.TextField(verbose_name="Ghi chú địa chỉ")
    image_urls = models.TextField(verbose_name="Hình ảnh")
    latitude = models.FloatField(verbose_name="Vĩ độ")
    longitude = models.FloatField(verbose_name="Kinh độ")
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f"Hợp đồng: {self.contract_number}"

    class Meta:
        db_table = 'customer_locations'
        verbose_name = "Thông tin địa điểm khách hàng"
        verbose_name_plural = "Thông tin địa điểm khách hàng"
